/*
	Program Name: Polygon Drawer
	@author: Gonzales Cenelia
	website: www.ai-search.4t.com

    This program can be use to draw any polygon that is a "regular polygon",
	a "star polygon" or "star figure". The results are pretty cool! For more 
	informations about polygons in general,you can visit the following site: 
	http://mathworld.wolfram.com/RegularPolygon.html By the way,if you do like 
	these program,please dont forget to rate it. Because without any rating,
	i will not know how good or bad the program is.

    This code is copyrighted and has limited warranty.
*/


#include "mainfrm.h"
#include "resource.h"
#include "dialog.h"



BOOL CMainFrm::m_bDrawPolygon;
BOOL CMainFrm::m_bDefaultTimer;
BOOL CMainFrm::m_bNoTimer;
BOOL CMainFrm::m_bUpdate;
INT CMainFrm::m_nNumOfSides;
INT CMainFrm::m_nPolygonType;
INT CMainFrm::m_nDensity;
FLOAT CMainFrm::m_fTimerVal;


CMainFrm::CMainFrm() {
	Create( NULL, "Polygon Drawer 1.0" );
	CMenu menu;
	menu.LoadMenu(IDR_MENU1);
	SetMenu(&menu);
	m_bUpdate = 1;
	m_fTimerVal = 0;
	m_nPolygonType = -1;
	m_bDrawPolygon = 0;
}

CMainFrm::~CMainFrm() {
}

_Polygon polygon[] = {
	{ 3,  "Equilateral triangle" }, 
	{ 4,  "Square" }, 
	{ 5,  "Pentagon" }, 
	{ 6,  "Hexagon" }, 
	{ 7,  "Heptagon" },
	{ 8,  "Octagon" }, 
	{ 9,  "Nonagon" }, 
	{ 10, "Decagon" }, 
	{ 11, "Undecagon" }, 
	{ 12, "Dodecagon" }, 
	{ 17, "Heptadecagon" }
};

_PolygonFigure figure[] = {
	{ 5,  2,  "Pentagram" },
	{ 6,  2,  "Hexagram" },
	{ 7,  2,  "Heptagram" },
	{ 8,  3,  "Octagram" },
	{ 8,  2,  "Star of Lakshmi" },
	{ 9,  3,  "Nonagram" },
	{ 10, 3,  "Decagram" }
};

BEGIN_MESSAGE_MAP( CMainFrm, CFrameWnd )
	ON_WM_PAINT()
	ON_COMMAND(ID_FILE_NEW_POLYGON, OnFileNewPolygon)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_FILE_EXIT, OnExit)
END_MESSAGE_MAP()


void CMainFrm::OnExit() {
	DestroyWindow();
}

void CMainFrm::OnPaint() {
	PAINTSTRUCT ps;
	CDC *pDC = BeginPaint(&ps);
	if (m_bDrawPolygon == 1) {
		 if(m_bUpdate) {
			 Invalidate(1);
			 m_bUpdate = 0;
		}
		switch(m_nPolygonType) {
		case 0:
			DrawRegularPolygon(pDC);
			break;
		case 1:
			DrawStarFigure(pDC);
			break;
		case 2:
			SuperposeStarFigure(pDC);
			break;
		}
	}
	EndPaint(&ps);
}

void CMainFrm::OnFileNewPolygon() {
	CDialogClass *dlg = new CDialogClass;
	dlg->Create(IDD_DIALOG2);
	dlg->ShowWindow(SW_SHOW);
}

// creates the "about dialog box"
void CMainFrm::OnHelpAbout() {
	CDialogClass *dlg = new CDialogClass;
	dlg->Create(IDD_DIALOG1);
	dlg->ShowWindow(SW_SHOW);
}

// makes the selection to draw or to not
// draw a polygon
void CMainFrm::SetPolygonDrawing( int bDraw ) {
	m_bDrawPolygon = bDraw;
}

// sets number of sides for a polygon
// before starting to draw the polygon
void CMainFrm::SetNumOfSides( int nNum ) {
	m_nNumOfSides = nNum;
}

// selecting the type of timer to be use
void CMainFrm::SetDefaultTimer( int bVal ) {
	m_bDefaultTimer = bVal; 
}

void CMainFrm::SetTimerVal( float nTimerVal ) {
	m_fTimerVal = nTimerVal;
}

// makes the selection for the type
// of polygon to be drawn
void CMainFrm::SetPolygonType( int nType ) {
	m_nPolygonType = nType;
}

// sets the density for a polygon figure
void CMainFrm::SetDensity( int nDensity ) {
	m_nDensity = nDensity;
}

// finds the name of the current star figure
void CMainFrm::FindStarFigureName( int p, int q ) {
	m_sPolygonFigureName.Empty();
	if ( p > 4 && p < 11 && q > 0 ) {
		 int size = sizeof(figure)/sizeof(figure[0]);
		 for( int i = 0; i < size; ++i ) {
			if ( figure[i].p == p && figure[i].q == q ) {
				 m_sPolygonFigureName = figure[i].name;
				 break;
			}
		}
	}
}

// finds the name of the current polygon 
void CMainFrm::FindPolygonName( int p ) {
	m_sPolygonName.Empty();
	if( p > 2 ) {
		if( p < 13 || p == 17 ) {
			int size = sizeof(polygon)/sizeof(polygon[0]);
			for( int i = 0; i < size; ++i ) {
				if(polygon[i].numOfSide == p) {
					m_sPolygonName = polygon[i].name;
					break;
				}
			}
		}
		else if( p > 12 ) {
			m_sPolygonName.Format("%d-gon", p );
		}
	}
}

// draw a regular polygon to the main window of the program
void CMainFrm::DrawRegularPolygon( CDC *pDC ) {
	CRect lpRect;
	m_bDrawPolygon = 1;
	GetClientRect( &lpRect );
	int a = -lpRect.right/2;
	int b = -lpRect.bottom/2;
	pDC->SetWindowOrg( a, b );
	int N = m_nNumOfSides;
	int X = -a/2 - 6, Y = -b/2 - 6;
	double theta = 2*PI/N;
	double angle = atan(Y/X);
	double R = sqrt(X*X + Y*Y);
	for( int i = 0; i < N + 1; ++i ) {
		angle += theta;
		X = (int)(R * cos(angle));
		Y = (int)(R * sin(angle));
		if(m_bDefaultTimer) { 
			WAIT( 1/(float)(N-1) * SECOND );
		}
		else if(m_fTimerVal > 0) {
			WAIT( m_fTimerVal * SECOND );
		}
		if( i > 0 ) { 
			pDC->LineTo( X, Y );
		}
		else {
			pDC->MoveTo( X, Y );
		}
	}
	if( m_nPolygonType == 0 ) {
		FindPolygonName(N);
		pDC->SetWindowOrg( 0, 0 );
		pDC->SetTextAlign(TA_CENTER);
		pDC->TextOut( -a, -b * 1.91, m_sPolygonName );
	}
}

// draw a star figure on the main window
void CMainFrm::DrawStarFigure( CDC *pDC ) {
	CRect lpRect;
	int N = m_nNumOfSides;
	GetClientRect( &lpRect );
	int a = -lpRect.right/2;
	int b = -lpRect.bottom/2;
	pDC->SetWindowOrg( a, b );
	std::vector<int> PtVector(N+1);
	CPoint *PtLine = new CPoint[N+1];
	int X = -a/2 - 6, Y = -b/2 - 6;
	double theta = 2*PI/N;
	double angle = atan(Y/X);
	double R = sqrt(X*X + Y*Y);
	for( int i = 0; i < N + 1; ++i ) {
		angle += theta;
		X = (int)(R * cos(angle));
		Y = (int)(R * sin(angle));
		PtLine[i].x = X;
		PtLine[i].y = Y;
		PtVector[i] = i;
	}
	int next_pos = 0, j = 0;
	std::vector<int>::iterator iter;
	while( j < PtVector.size()) {
		next_pos = PtVector[j++];
		pDC->MoveTo(PtLine[next_pos]);
		for( i = 0; i < N; ++i ) {
			next_pos += m_nDensity;
			if ( next_pos >= N ) {
				next_pos %= N;
			}
			iter = std::find( PtVector.begin(), PtVector.end(), next_pos );
			if (iter != PtVector.end()) {
				if (m_bDefaultTimer) { 
					WAIT( 1/(float)(N-1) * SECOND );
				}
				else if (m_fTimerVal > 0) {
					WAIT( m_fTimerVal * SECOND );
				}
				pDC->LineTo(PtLine[next_pos]);
				PtVector.erase(iter);
			}
			else {
				break;
			}
		}
	}
	if( m_nPolygonType == 1 ) {
		FindStarFigureName( N, m_nDensity );
		if (m_sPolygonFigureName.GetLength() > 0) {
			pDC->SetWindowOrg( 0, 0 );
			pDC->SetTextAlign(TA_CENTER);
			pDC->TextOut( -a, -b * 1.91, m_sPolygonFigureName );
		}
	}
	delete PtLine;
}

// draw a superposition of star figures
void CMainFrm::SuperposeStarFigure( CDC *pDC ) {
	int p = m_nNumOfSides;
	for(int q = 2; q < p - 1; ++q) {
		m_nDensity = q;
		DrawStarFigure(pDC);
	}
	DrawRegularPolygon(pDC);
}



